/**
 *
 * \file        hprfgw_rftrans.h
 *
 * \brief       The RF transmit function header file.		
 *
 * \detial      
 * \author      Hazrat Shah	
 *
 * \date        08/29/2006
 * \warning		
 * \note
 * \review	
 *
 */
#ifndef _HPRFGW_RFREC_H_
	#define _HPRFGW_RFREC_H_

#include "hprfgw_config.h"
//#include "datatypes.h"
#include "hprfgw_rfSharedDefs.h"
#include "hprfgw_rfNwkMacInterface.h"
#include "hprfgw_rfRetry.h"

////////////////////////////////////////////////////////////////////////////////
//  Definitions
////////////////////////////////////////////////////////////////////////////////
#define UID_MAX_SIZE                            8                   //
#define PANID_MAX_SIZE                          2                   //
#define GATEWAY_NAME_MAX_SIZE                   50                  //

#define RF_FIRST_CHANNEL                        gLogicalChannel11_c
#define RF_LAST_CHANNEL                         gLogicalChannel26_c
#define RF_MAX_CHANNELS                         (RF_LAST_CHANNEL-RF_FIRST_CHANNEL+1)

//  RF power level range at the rf PHY chip
#define RF_PHY_MAX_POWER_LEVEL                  RF_PHY_POWER_LEVEL21// maximum allowable rf phy level power
                                                                    //  PHY values  dBm
#define RF_PHY_POWER_LEVEL21                    21                  //  FF
#define RF_PHY_POWER_LEVEL20                    20                  //  FE
#define RF_PHY_POWER_LEVEL19                    19                  //  FD
#define RF_PHY_POWER_LEVEL18                    18                  //  FC
#define RF_PHY_POWER_LEVEL17                    17                  //  EC
#define RF_PHY_POWER_LEVEL16                    16                  //  DC
#define RF_PHY_POWER_LEVEL15                    15                  //  CC
#define RF_PHY_POWER_LEVEL14                    14                  //  BC
#define RF_PHY_POWER_LEVEL13                    13                  //  AC
#define RF_PHY_POWER_LEVEL12                    12                  //  9C
#define RF_PHY_POWER_LEVEL11                    11                  //  8C
#define RF_PHY_POWER_LEVEL10                    10                  //  7C
#define RF_PHY_POWER_LEVEL9                     9                   //  6C
#define RF_PHY_POWER_LEVEL8                     8                   //  5C
#define RF_PHY_POWER_LEVEL7                     7                   //  4C
#define RF_PHY_POWER_LEVEL6                     6                   //  3C
#define RF_PHY_POWER_LEVEL5                     5                   //  2C
#define RF_PHY_POWER_LEVEL4                     4                   //  1C
#define RF_PHY_POWER_LEVEL3                     3                   //  C
#define RF_PHY_POWER_LEVEL2                     2                   //  8
#define RF_PHY_POWER_LEVEL1                     1                   //  4
#define RF_PHY_POWER_LEVEL0                     0                   //  0

//  power level settings from user menu (used as an index to lookup PHY levels based on the
//  current selected channel)
#define RF_POWER_LO                             0                   //
#define RF_POWER_HI                             1                   //

//  Default gateway parameters
#define GATEWAY_DEFAULT_PANID                   0xFEED              //  Used if no other net on same channel
#define GATEWAY_ADDR_MODE                       gAddrModeLong_c     //  long addressing mode (uid=8-bytes)
#define GATEWAY_SHORT_ADDR                      0xFFFE              //  Setting the short UID to 0xFFFE informs the device to use the long 8-byte UID
#define GATEWAY_DEFAULT_CHANNEL                 20                  //  RF channel
#define GATEWAY_DEFAULT_POWER                   RF_POWER_HI         //  default rf Power
#define GATEWAY_DEFAULT_NAME                    "HPRFGW"            //  Gateway and first 6 chars of UID
#define GATEWAY_DEFAULT_CCAENERGY_THRESHOLD     0x96                //  CCA Energy threshold (10/05/07 - changed from 0x80=-65dBm to 0x96=-75dBm)
#define GATEWAY_DEFAULT_RSSIPOWERCOMPOFFSET     0xB5                //  Power offset added to RSSI (10/05/07 - changed from 0x74 to recommended def 0x8D)

extern const   UINT8   GATEWAY_DEFAULT_UID[UID_MAX_SIZE];			// Default UID
extern const   UINT8   GATEWAY_DEFAULT_RETRDEL[RF_MAX_NO_OF_RETRIES_DELAYS];

//	Default slave device parameters
#define	SLAVE_DEVICE_DEFAULT_PANID				0xFEED				//	RF slave device panid
#define	SLAVE_DEVICE_ADDR_MODE					gAddrModeLong_c		//	long addressing mode (uid=8-bytes)
#define	SLAVE_DEVICE_SHORT_ADDR 				0xFFFE				//	Setting the short UID to 0xFFFE informs the device to use the long 8-byte UID
#define	SLAVE_DEVICE_DEFAULT_CHANNEL			20					//	RF channel
#define	SLAVE_DEVICE_DEFAULT_POWER				RF_POWER_HI			//	default Power level 	
#define	SLAVE_DEVICE_DEFAULT_CCAENERGY_THRESHOLD 0x96				//	CCA Energy threshold (10/05/07 - changed from 0x80=-65dBm to 0x96=-75dBm)
#define	SLAVE_DEVICE_DEFAULT_RSSIPowerCompOffset 0xB5				//	Power offset added to RSSI (10/05/07 - changed from 0x74 to recommended def 0x8D) 
extern const   UINT8   SLAVE_DEVICE_DEFAULT_UID[UID_MAX_SIZE];		// Default UID
extern const   UINT8   SLAVE_DEVICE_DEFAULT_RETRDEL[RF_MAX_NO_OF_RETRIES_DELAYS];

//	rf power level table
typedef	struct	{
	UINT8	low;
	UINT8	high;
}	TYPE_RF_POWER_LIMITS;
extern	TYPE_RF_POWER_LIMITS RFPowerLmts[][27];	
extern  UINT8   gPowerBoost;
////////////////////////////////////////////////////////////////////////////////										   
//	Data Prototypes	
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//	Function declaractions	
////////////////////////////////////////////////////////////////////////////////
#ifdef  __cplusplus
extern "C" 
{
#endif

void 	RFReceive_Init(void);		

extern	void 	RFReceive_GetLocalDeviceUID (UINT8 *puid);	
extern	UINT16	RFReceive_SetLocalDeviceUID (UINT8 *puid);
extern	UINT16 	RFReceive_GetLocalDevicePanID (void);
extern	UINT16	RFReceive_SetLocalDevicePanID (UINT16 panid);
extern	UINT16 	RFReceive_GetLocalDevicePanIDLittleIndian (void);			
extern	UINT16 	RFReceive_GetLocalDeviceShortAddr (void);
extern  UINT16	RFReceive_SetLocalDeviceShortAddr (UINT16 shortaddr);
extern	UINT16 	RFReceive_GetLocalDeviceShortAddrLittleIndian (void);			
extern	UINT8 	RFReceive_GetLocalDeviceAddrMode (void);		
extern	UINT16	RFReceive_SetLocalDeviceAddrMode (UINT8 addrmode);
extern	void	RFReceive_GetLocalDeviceName (INT8 *pname);
extern	UINT8	RFReceive_GetLocalDeviceRetry (void);	
extern	UINT16	RFReceive_SetLocalDeviceRetry (UINT8 RetryCnt);
extern	UINT8	RFReceive_GetLocalDeviceRetryOnConnectionReq (void);			
extern	UINT16	RFReceive_SetLocalDeviceRetryOnConnectionReq (UINT8 RetryCnt);			
extern	UINT8	RFReceive_GetLocalDeviceRetryDelayAtRetryCount (UINT8 retry);	
extern	UINT16	RFReceive_SetLocalDeviceRetryDelay (UINT8 *pRetryDly, UINT8 count, UINT8 index);
extern	UINT16	RFReceive_GetLocalDeviceRetryDelay (UINT8 *pRetryDly, UINT8 count, UINT8 index);

extern	UINT16	RFReceive_SetLocalDeviceUIDValid (BOOL Valid);	
extern	UINT16	RFReceive_GetLocalDevicePower (void);		
extern	UINT16	RFReceive_SetLocalDevicePower (UINT16 power);
extern	UINT16	RFReceive_SetLocalDeviceChannel (UINT8 Channel); 
extern	UINT16	RFReceive_GetLocalDeviceResultCodeTimeout (void);
extern	UINT16	RFReceive_SetLocalDeviceResultCodeTimeout (UINT16 ResultCodeTimeout);

extern	UINT16	RFReceive_SetGatewayUIDValid (BOOL Valid);
extern	UINT16	RFReceive_SetLocalDeviceCCAEnergyDetectThr (UINT8 CCAEnergyDetectThr);
extern	UINT8	RFReceive_GetLocalDeviceCCAEnergyDetectThr (void);
extern	UINT16	RFReceive_SetLocalDeviceRSSIPowerCompOffset (UINT8 RSSIPowerCompOffset);
extern	UINT8	RFReceive_GetLocalDeviceRSSIPowerCompOffset (void);


extern	UINT8 	RFReceive_GetLocalDeviceHeartBeatTimeout (void);
extern	UINT16  RFReceive_SetLocalDeviceHeartBeatTimeout (UINT8 Heartbeat);

extern	void 	RFReceive_SetResultCodeTimeoutEvent (void);
extern	void 	RFReceive_SetRetryTimeoutEvent (void);	
extern	void 	RFReceive_SetHeartBeatTimeoutEvent (void);			

extern	BOOL	RFReceive_IsRFStackInitialized (void);
extern	BOOL	RFReceive_IsGatewayUIDValid (void);			
extern	BOOL	RFReceive_IsLocalDeviceUIDValid (void);
extern	BOOL	RFReceive_IsLocalDeviceConnectedToGateway (void);

extern	UINT16 	RFReceive_DisableTimerInterrupt (void);
extern	UINT16 	RFReceive_EnableTimerInterrupt (void);

extern	void	RFReceive_GetGatewayUID (UINT8 *puid);
extern	UINT16  RFReceive_GetGatewayPANID (void);
extern	UINT8	RFReceive_GetLocalDeviceSecurity (void);
extern	UINT8	RFReceive_GetLocalDeviceChannel (void);
extern	UINT8	RFReceive_GetLocalDeviceCCAEnergyThr (void);
extern	UINT8	RFReceive_GetLocalDeviceRSSIPowerCompThr (void);

extern	BOOL	RFReceive_IsGatewayConnected (void);
extern	BOOL	RFReceive_IsControlSystemConnected (void);	
extern	void	RFReceive_SetGatewayConnectStatus (BOOL ConnStatus);	
extern	void	RFReceive_SetControlSystemConnectedStatus (BOOL ConnStatus, BOOL SendUpdReq);	
extern	UINT16	RFReceive_GetTimerValue (void);
extern	UINT16	RFReceive_DisableTimerInterrupt(void);
extern	UINT16	RFReceive_EnableTimerInterrupt(void);
extern 	UINT16	RFReceiver_RFStackMsgQueInit (void);
extern  UINT8	RFReceive_TranslatePowerToPHYLimits(UINT16 power);
extern  UINT16  RFReceive_GetLocalDeviceRetryDelayAtIndex (UINT8 index, UINT8 *dly);
extern	UINT32	RFReceiver_GetTotalRetryDlyTimeInSeconds (void);	
extern	BOOL	RFReceive_IsControlSystemConnectedNetTypeCresnet (void);	
extern	void	RFReceive_SetControlSystemConnectedNetTypeCresnet (BOOL Status);	
extern	BOOL	RFReceive_IsControlSystemConnectedNetTypeEthernet(void);
extern	void	RFReceive_SetControlSystemConnectedNetTypeEthernet (BOOL Status);
extern	UINT8	RFReceive_ConvertLinkQuality(UINT8 linkQuality);
extern	UINT8	RFReceive_ConvertEnergyLevel(UINT8 energyLevel);
extern	float	RFReceive_ConvertPowerTodBm (UINT16 power, BOOL Translate);
extern	float	RFReceive_ConvertPowerTomWatts (UINT16 power, BOOL Translate);
extern	float	RFReceive_ConvertLinkQualityTomWatts(UINT8 linkQuality);
extern	INT8	RFReceive_ConvertLinkQualityTodBm (UINT8 linkQuality);
extern	UINT16	RFReceive_ConvertLinkQualityToIEEEWord (UINT8 linkQuality, INT8 offset);
extern	UINT8	RFReceive_ConvertLinkQualityToPercent (UINT8 linkQuality, INT8 offset);

extern  void	RFReceive_Timer_HISR_Function(void);
extern  UINT8	RFReceive_GetLocalDeviceRFLinkLQIThr (void);			
extern  UINT16	RFReceive_SetLocalDeviceRFLinkLQIThr (UINT8 LQI);			
extern  UINT8   RFReceive_GetLocalDevicePreLinkQueryPacketCnt (void);	
extern  UINT16  RFReceive_SetLocalDevicePreLinkQueryPacketCnt (UINT8 Cnt);

#ifdef  __cplusplus
}
#endif



#endif
/**/
